class PileVideErreur(Exception):
    """
    exception pour Pile vide
    """
    def __init__(self, msg):
        self.message = msg

class Pile:
    """
    une classe pour manipuler les Piles
    """

    def __init__(self):
        """
        constructeur de pile
        """
        self.__contenu = []

    def est_vide(self):
        """
        Teste la vacuité de la Pile
        :return: (bool) True si la Pile est vide, False sinon
        :CU: None
        :Exemples:

        >>> p = Pile()
        >>> p.est_vide()
        True
        >>> p.empile(1)
        >>> p.est_vide()
        False
        """
        return self.__contenu == []

    def empile(self, el):
        """
        :param el: (any) un élément
        :return: None
        :Side-Effet: ajoute un élément au sommet de la Pile
        :CU: None

        >>> p = Pile()
        >>> p.empile(1)
        >>> p.depile() == 1
        True
        """
        self.__contenu.append(el)

    def depile(self):
        """
        :return: (any) l'élément au sommet de la Pile
        :CU: la Pile ne doit pas être vide
        :raise: PileEmptyError
        :Side-Effect: la pile est modifiée
        :Exemples:

        >>> p = Pile()
        >>> p.empile(1)
        >>> p.depile() == 1
        True
        >>> p.est_vide()
        True
        """
        if self.est_vide():
            raise PileVideErreur("Une Pile vide ne peut être dépilée")
        else:
            return self.__contenu.pop()

    def haut(self):
        """
        :return: (any) l'élément au sommet de la Pile
        :CU: la Pile ne doit pas être vide
        :raise: PileEmptyError
        :Exemples:

        >>> p = Pile()
        >>> p.empile(1)
        >>> p.haut() == 1
        True
        >>> p.est_vide()
        False
        """
        if self.est_vide():
            raise PileVideErreur("Une Pile vide n'a pas de haut")
        else:
            return self.__contenu[0]

    def __repr__(self):
        """
        >>> p=Pile()
        >>> p.empile(1)
        >>> p.empile(2)
        >>> p.empile(3)
        >>> p
        3\r
        2\r
        1\r
        <BLANKLINE>
        """
        resultat = ""
        pile = self
        while not pile.est_vide():
            resultat += str(pile.depile()) + "\r\n"
        return resultat
        
if __name__ == "__main__":
    import doctest
    doctest.testmod(verbose=True)



