class Duree():
    def __init__(self,annees, jours, heures, minutes, secondes):
        """
        constructeur: initialise les états d'un objet de type Duree
        :param self:(Duree) un objet de type Duree
        :param annees:(int) un entier
        :param jours:(int) un entier
        :param heures:(int) un entier
        :param minutes:(int) un entier
        :param secondes:(int) un entier
        :return: (Nonetype)
        :CU: annees >= 0
            0 <= jours < 365
            0 <= heures < 24
            0 <= minutes < 60
            0 <= secondes < 60
        """
        self.__annee = annees
        self.__jour = jours
        self.__heure = heures
        self.__minute = minutes
        self.__seconde = secondes
    
    def get_secondes(self):
        """
        sélecteur: renvoie la valeur de __secondes de l'objet de type Duree
        :param self:(Duree) un objet de type Duree
        :Exemple:
        >>> duree1 = Duree(1,2,3,4,5)
        >>> duree1.get_secondes()
        5
        """
        return self.__seconde
    
    def get_minutes(self):
        """
        sélecteur: renvoie la valeur de __minutes de l'objet de type Duree
        :param self:(Duree) un objet de type Duree
        :Exemple:
        >>> duree1 = Duree(1,2,3,4,5)
        >>> duree1.get_minutes()
        4
        """
        return self.__minute
    
    def get_heures(self):
        """
        sélecteur: renvoie la valeur de __heures de l'objet de type Duree
        :param self:(Duree) un objet de type Duree
        :Exemple:
        >>> duree1 = Duree(1,2,3,4,5)
        >>> duree1.get_heures()
        3
        """
        return self.__heure
    
    def get_jours(self):
        """
        sélecteur: renvoie la valeur de __jours de l'objet de type Duree
        :param self:(Duree) un objet de type Duree
        :Exemple:
        >>> duree1 = Duree(1,2,3,4,5)
        >>> duree1.get_jours()
        2
        """
        return self.__jour
    
    def get_annees(self):
        """
        sélecteur: renvoie la valeur de __annees de l'objet de type Duree
        :param self:(Duree) un objet de type Duree
        :Exemple:
        >>> duree1 = Duree(1,2,3,4,5)
        >>> duree1.get_annees()
        1
        """
        return self.__annee

    def __repr__(self):
        """
        renvoie la représentation d'un objet de type Duree
        :param self:(Duree) un objet de type Duree
        :return: (string) une chaine de caractère
        :Exemple:
        >>> duree1 = Duree(1,2,3,4,5)
        >>> duree1
        1a2j3h4min5s
        """
        return str(self.__annee)+'a'+str(self.__jour)+'j'+str(self.__heure)+'h'+str(self.__minute)+'min'+str(self.__seconde)+'s'

    def __add__(self, autre):
        """
        ajoute deux objets de type Duree: self et autre
        :param self:(Duree) un objet de type Duree
        :param autre:(Duree) un objet de type Duree
        :Exemple:
        >>> duree1 = Duree(1,2,15,4,50)
        >>> duree2 = Duree(3,61,11,4,20)
        >>> duree1 + duree2
        4a64j2h9min10s
        """
        nouv_sec, retenue_sec = (self.__seconde+autre.get_secondes())%60, (self.__seconde+autre.get_secondes())//60
        nouv_min, retenue_min = (self.__minute+autre.get_minutes()+retenue_sec)%60, (self.__minute+autre.get_minutes()+retenue_sec)//60
        nouv_heu, retenue_heu = (self.__heure+autre.get_heures()+retenue_min)%24, (self.__heure+autre.get_heures()+retenue_min)//24
        nouv_jou, retenue_jou = (self.__jour+autre.get_jours()+retenue_heu)%365, (self.__jour+autre.get_jours()+retenue_heu)//365
        nouv_ann = self.__annee + autre.get_annees() + retenue_jou
        return Duree(nouv_ann, nouv_jou, nouv_heu, nouv_min, nouv_sec)
    
    def __sub__(self, autre):
        """
        soustrait deux objets de type Duree: self et autre
        :param self:(Duree) un objet de type Duree
        :param autre:(Duree) un objet de type Duree
        :CU: self > autre
        :Exemple:
        >>> duree1 = Duree(1,2,15,4,50)
        >>> duree2 = Duree(3,61,11,4,20)
        >>> duree2 - duree1
        2a58j19h59min30s
        >>> duree1 = Duree(0,0,1,1,1)
        >>> duree2 = Duree(0,0,1,1,2)
        >>> duree1 - duree2
        on ne peut pas soustraire ces deux durées:0a0j1h1min1s < 0a0j1h1min2s
        """
        if self.__seconde - autre.get_secondes() < 0:
            nouv_sec = 60 + self.__seconde-autre.get_secondes()
            retenue_sec = 1
        else :
            nouv_sec = self.__seconde-autre.get_secondes()
            retenue_sec=0
        if self.__minute - autre.get_minutes() - retenue_sec < 0:
            nouv_min = 60 + self.__minute-autre.get_minutes() - retenue_sec
            retenue_min = 1
        else :
            nouv_min = self.__minute - autre.get_minutes() - retenue_sec
            retenue_min = 0
        if self.__heure - autre.get_heures() - retenue_min < 0:
            nouv_heu = 24 + self.__heure - autre.get_heures() - retenue_min
            retenue_heu = 1
        else :
            nouv_heu = self.__heure - autre.get_heures() - retenue_min
            retenue_heu = 0
        if self.__jour - autre.get_jours() - retenue_heu < 0:
            nouv_jou = 365 + self.__jour - autre.get_jours() - retenue_heu
            retenue_jou = 1
        else :
            nouv_jou = self.__jour - autre.get_jours() - retenue_heu
            retenue_jou = 0
        nouv_ann = self.__annee - autre.get_annees() - retenue_jou
        if self.__annee > autre.get_annees():
            return Duree(nouv_ann, nouv_jou, nouv_heu, nouv_min, nouv_sec)
        else :
            print ('on ne peut pas soustraire ces deux durées:' + self.__repr__() + ' < ' + autre.__repr__())

    def __mul__(self,nombre):
        """
        multiplie un objet de type Duree par un entier
        :param self:(Duree) un objet de type Duree
        :param nombre:(int) un entier
        :CU: nombre > 0
        :Exemple:
        >>> duree1 = Duree(1,2,15,4,50)
        >>> duree1 * 2
        2a5j6h9min40s
        """
        nouv_sec, retenue_sec = (self.__seconde * nombre) % 60, (self.__seconde * nombre) // 60
        nouv_min, retenue_min = (self.__minute * nombre + retenue_sec) % 60, (self.__minute * nombre + retenue_sec) // 60
        nouv_heu, retenue_heu = (self.__heure * nombre + retenue_min) % 24, (self.__heure * nombre + retenue_min) // 24
        nouv_jou, retenue_jou = (self.__jour * nombre + retenue_heu) % 365,(self.__jour * nombre + retenue_heu) // 365
        nouv_ann = self.__annee * nombre + retenue_jou
        return Duree(nouv_ann, nouv_jou, nouv_heu, nouv_min, nouv_sec)
    
if __name__ == "__main__":
    import doctest
    doctest.testmod(verbose=True)    