class Maillon:
    def __init__(self, valeur, suivant):
        self.__valeur = valeur
        self.__suivant = suivant
    
    def est_vide(self):
        '''
        Renvoie True si le Maillon est vide.
        :return: True si le Maillon n'a pas d'élément, False sinon
        :Exemples:
        >>> Maillon(None, None).est_vide()
        True
        >>> Maillon(1, None).est_vide()
        False
        '''
        return self.__valeur == None and self.__suivant == None
    
    def donne_valeur(self):
        '''
        Renvoie la valeur du maillon.
        :return: (any)
        :Exemples:
        >>> m = Maillon(1, None)
        >>> m.donne_valeur()
        1
        '''
        return self.__valeur
    
    def donne_suivant(self):
        '''
        Renvoie le maillon vers lequel pointe self.
        :return: (Maillon ou NoneType)
        :Exemples:
        >>> m = Maillon(1, None)
        >>> m.donne_suivant() == None
        True
        >>> m = Maillon(3, m)
        >>> type(m.donne_suivant()) == Maillon
        True
        >>> m.donne_suivant().donne_valeur()
        1
        '''
        return self.__suivant
    
    def modifie_suivant(self, maillon):
        '''
        Modifie le pointeur du maillon vers le maillon mis en paramètre.
        :maillon:(Maillon)
        :return: (NoneType)
        :Exemples:
        >>> m = Maillon(1, None)
        >>> m
        1 -> None
        >>> n = Maillon(3, None)
        >>> m.modifie_suivant(n)
        >>> m
        1 -> 3
        '''
        self.__suivant = maillon
    
    def __repr__(self):
        if self.__suivant != None:
            res = str(self.__valeur) + ' -> ' + str(self.__suivant.donne_valeur())
        else:
            res = str(self.__valeur) + ' -> None'
        return res

class ListeChainee:
    def __init__(self):
        self.__valeur = Maillon(None, None)
    
    def est_vide(self):
        '''
        Renvoie True si la Liste chainée est vide.

        :return: True si la Liste chainée n'a qu'un maillon vide, False sinon
        :Exemples:
        >>> a = ListeChainee()
        >>> a.est_vide()
        True
        >>> a.ajoute_valeur(1)
        >>> a.est_vide()
        False
        '''
        return self.__valeur.est_vide()
    
    def ajoute_valeur(self, valeur):
        """
        Ajoute une valeur en début de liste chainée.
        :param valeur:(any)
        :return: (NoneType)
        >>> a = ListeChainee()
        >>> a.ajoute_valeur(5)
        >>> a
        5 -> None
        >>> a.ajoute_valeur(7)
        >>> a
        7 -> 5 -> None
        >>> a.ajoute_valeur(9)
        >>> a
        9 -> 7 -> 5 -> None
        """
        self.__valeur = Maillon(valeur, self.__valeur)
    
    def __repr__(self):
        res = ''
        maillon = self.__valeur
        while not maillon.est_vide():
            res += str(maillon.donne_valeur()) + ' -> '
            maillon = maillon.donne_suivant()
        res += 'None'
        return res
        
    def tete(self):
        '''
        Renvoie la tête de la Liste

        :return: premier élément d'une Liste
        :Exemples:
        >>> a = ListeChainee()
        >>> a.tete()
        Traceback (most recent call last):
        ...
        AssertionError: une Liste chainée vide n'a pas de tête
        >>> a.ajoute_valeur(5)
        >>> a.tete()
        5
        '''
        assert not self.est_vide(), "une Liste chainée vide n'a pas de tête"
        return self.__valeur.donne_valeur()
    
    def reste(self):
        '''
        Renvoie la tête de la Liste

        :return: premier élément d'une Liste
        :Exemples:
        >>> a = ListeChainee()
        >>> a.reste()
        Traceback (most recent call last):
        ...
        AssertionError: une Liste chainée vide n'a pas de reste
        >>> a.ajoute_valeur(5)
        >>> a.reste().est_vide()
        True
        '''
        assert not self.est_vide(), "une Liste chainée vide n'a pas de reste"
        return self.__valeur.donne_suivant()
    
    def longueur(self):
        """
        Renvoie la longueur de la liste
        :return:(int) un entier
        >>> a = ListeChainee()
        >>> a.ajoute_valeur(5)
        >>> a.ajoute_valeur(7)
        >>> a.ajoute_valeur(9)
        >>> a.longueur()
        3
        """
        long = 0
        maillon = self.__valeur
        while not maillon.est_vide():
            long += 1
            maillon = maillon.donne_suivant()
        return long
    
    def insere_valeur(self, emplacement, valeur):
        """
        >>> a = ListeChainee()
        >>> a.ajoute_valeur(5)
        >>> a.ajoute_valeur(7)
        >>> a.ajoute_valeur(9)
        >>> a.insere_valeur(2, 8)
        >>> a
        9 -> 7 -> 8 -> 5 -> None
        """
        assert emplacement <= self.longueur()
        indice = 0
        maillon = self.__valeur
        while indice != emplacement-1:
            maillon = maillon.donne_suivant()
            indice += 1
        le_suivant = maillon.donne_suivant()
        l_actuel = Maillon(valeur, le_suivant)
        maillon.modifie_suivant(l_actuel)


if __name__ == "__main__":
    import doctest
    doctest.testmod(verbose=False)
