
class Liste(object):

    def __init__ (self, *args):
        '''
        Construit une nouvelle Liste.
        Cette Liste peut être:
        * vide;
        * construite à partir d'un élément et d'une autre Liste.

        Il y aura donc soit aucun argument soit deux arguments.

        :param *args: les arguments de la fonction. soit il n'y en a pas, soit il y en a deux (le second doit être une Liste).
        :CU: len(args) == 0 or (len(args) == 2 and args[1] est une Liste)
        '''
        assert len(args) == 0 or len(args) == 2, "il n'y a pas le bon nombre d'arguments"
        if len(args) == 0:
            # aucun paramètre: construction de la List vide
            self.__cellule = None
        else:
            # deux paramètres: un élément et une List
            assert type(args[1]) == Liste, "Le second argument doit être une Liste"
            self.__cellule = (args[0],args[1])

    def est_vide (self):
        '''
        Renvoie True si la Liste est vide.

        :return: True si la liste n'a pas d'élément, False sinon
        :Exemples:
        >>> Liste().est_vide()
        True
        >>> Liste(1, Liste()).est_vide()
        False
        '''
        return self.__cellule == None

    def tete (self):
        '''
        Renvoie la tête de la Liste

        :return: premier élément d'une Liste
        :Exemples:
        >>> l=Liste(1, Liste())
        >>> l.tete()
        1
        >>> l = Liste(2, Liste(1, Liste()))
        >>> l.tete()
        2
        >>> l = Liste()
        >>> l.tete()
        Traceback (most recent call last):
        ...
        AssertionError: une Liste vide n'a pas de tête
        '''
        
        assert not self.est_vide(), "une Liste vide n'a pas de tête"
        return self.__cellule[0]
    
    def reste(self):
        '''
        Renvoie le reste de la liste (privé de la tête)

        :return: la liste sans le premier élément
        :Exemples:
        >>> l=Liste(1, Liste())
        >>> l.reste()
        ()
        >>> l = Liste(2, Liste(1, Liste()))
        >>> l.reste()
        (1.())
        >>> l = Liste()
        >>> l.reste()
        Traceback (most recent call last):
        ...
        AssertionError: une Liste vide n'a pas de reste
        '''
        assert not self.est_vide(), "une Liste vide n'a pas de reste"
        return self.__cellule[1]
        
    def __repr__ (self):
        """
        Renvoie la représentation de la Liste
        :Exemples:
        >>> l = Liste(1,(Liste(2,(Liste(3,Liste())))))
        >>> l
        (1.(2.(3.())))
        >>> Liste()
        ()
        """
        if self.est_vide():
            return '()'
        else:
            return '('+repr(self.tete())+'.'+repr(self.reste())+')'

    def longueur(self):
        """
        Renvoie la longueur de la Liste
        
        :return: nombre d'éléments dans la Liste
        :Exemples:
        >>> l = Liste()
        >>> l.longueur()
        0
        >>> l = Liste(3,l)
        >>> l = Liste(2,l)
        >>> l = Liste(1,l)
        >>> l.longueur()
        3
        """
        if self.est_vide():
            long = 0
        else:
            liste = self.reste()
            long=1
            while not liste.est_vide():
                long += 1
                liste=liste.reste()
        return long
    
    def donne_element(self,i):
        '''
        Renvoie l'élément de position i (les positions commencent à l'indice 0).
        
        :CU: not self.est_vide()
        :Exemples:
        >>> l = Liste(1, Liste())
        >>> l.donne_element(0)
        1
        >>> l = Liste(4, Liste())
        >>> l = Liste(3,l)
        >>> l = Liste(2,l)
        >>> l = Liste(1,l)
        >>> l.donne_element(3)
        4
        >>> l.donne_element(0)
        1
        '''
        liste = self
        for k in range(i):
            liste = liste.reste()
        return liste.tete()
    
            
    def cherche_element(self, e):
        """
        Recherche si un élément existe dans la Liste

        :return: True si e est un élément de la Liste, False sinon
        
        >>> l = Liste()
        >>> l.cherche_element(0)
        False
        >>> l = Liste(3,l)
        >>> l = Liste(2,l)
        >>> l = Liste(1,l)
        >>> l.cherche_element(1)
        True
        >>> l.cherche_element(3)
        True
        >>> l.cherche_element(4)
        False
        """
        liste = self
        while not liste.est_vide() and liste.tete() != e:
            liste = liste.reste()
        if liste.est_vide():
            return False
        else:
            return True
    
    def enChaine(self):
        """
        Renvoie la représentation de la Liste sous forme d'une chaîne de caractères

        >>> l = Liste()
        >>> l = Liste(3,l)
        >>> l = Liste(2,l)
        >>> l = Liste(1,l)
        >>> l.enChaine()
        '1 2 3'
        """
        chaine=''
        liste = self
        for i in range(self.longueur()):
            chaine += str(liste.tete()) + ' '
            liste = liste.reste()
        if len(chaine) != 0:
            return chaine[:-1]
        else:
            return chaine

    def enTableau(self):
        """
        Renvoie la Liste (de type List) sous forme d'une liste Python (tableau)

        :return: Une liste Python dont les éléments et la longueur sont identiques à `self`.

        >>> l = Liste()
        >>> l.enTableau()
        []
        >>> l = Liste(3,l)
        >>> l = Liste(2,l)
        >>> l = Liste(1,l)
        >>> l.enTableau()
        [1, 2, 3]
        """
        listePython = []
        liste = self
        for i in range(self.longueur()):
            listePython.append(liste.tete())
            liste = liste.reste()
        return listePython

    def inverse(self):
        '''
        :return: une nouvelle List contenant les mêmes éléments que `self` mais dans l'ordre inverse.

        >>> l = Liste()
        >>> l = Liste(3,l)
        >>> l = Liste(2,l)
        >>> l = Liste(1,l)
        >>> l
        (1.(2.(3.())))
        >>> r = l.inverse()
        >>> r
        (3.(2.(1.())))
        '''        
        liste = self
        resultat = Liste()
        while not liste.est_vide():
            resultat = Liste(liste.tete(), resultat)
            liste = liste.reste()
        return resultat

if __name__ == "__main__":
    import doctest
    doctest.testmod(optionflags=doctest.NORMALIZE_WHITESPACE | doctest.ELLIPSIS, verbose=False)

