from les_listes import Liste

class Pile:
    
    def __init__(self):
        self.__valeur = Liste()
        
    def est_vide(self):
        """
        Teste la vacuité de la Pile
        :return: (bool) True si la Pile est vide, False sinon
        :CU: None
        :Exemples:

        >>> p = Pile()
        >>> p.est_vide()
        True
        >>> p.empile(1)
        >>> p.est_vide()
        False
        """
        return self.__valeur.est_vide()

    def empile(self, el):
        """
        :param el: (any) un élément
        :return: None
        :Side-Effet: ajoute un élément au sommet de la Pile
        :CU: None

        >>> p = Pile()
        >>> p.empile(1)
        >>> p.depile() == 1
        True
        """
        self.__valeur = Liste(el, self.__valeur)

    def depile(self):
        """
        :return: (any) l'élément au sommet de la Pile
        :CU: la Pile ne doit pas être vide
        :raise: PileEmptyError
        :Side-Effect: la pile est modifiée
        :Exemples:

        >>> p = Pile()
        >>> p.empile(1)
        >>> p.depile() == 1
        True
        >>> p.est_vide()
        True
        """
        assert not self.est_vide(), "Une Pile vide ne peut être dépilée"
        haut = self.__valeur.tete()
        self.__valeur = self.__valeur.reste()
        return haut

    def haut(self):
        """
        :return: (any) l'élément au sommet de la Pile
        :CU: la Pile ne doit pas être vide
        :raise: PileEmptyError
        :Exemples:

        >>> p = Pile()
        >>> p.empile(1)
        >>> p.haut() == 1
        True
        >>> p.est_vide()
        False
        """
        assert not self.est_vide(), "Une Pile vide n'a pas de haut"
        return self.__valeur.tete()

    def __repr__(self):
        """
        >>> p=Pile()
        >>> p.empile(1)
        >>> p.empile(2)
        >>> p.empile(3)
        >>> p
        3\r
        2\r
        1\r
        <BLANKLINE>
        """
        resultat = ""
        pile = self
        while not pile.est_vide():
            resultat += str(pile.depile()) + "\r\n"
        return resultat
    
if __name__ == "__main__":
    import doctest
    doctest.testmod(verbose=False)