import les_piles

class FileVideErreur(Exception):
    def __init__(msg):
        super().__init__(msg)

class File:
    """
    Une classe représentant les Files

    >>> q = File()
    >>> q.est_vide()
    True
    >>> q.enfile(1)
    >>> q.enfile(2)
    >>> q.est_vide()
    False
    >>> q.defile()
    1
    >>> q.defile()
    2
    """

    def __init__(self):
        """
        Crée une nouvelle File
        """
        self.__contenu = les_piles.Pile()

    def est_vide(self):
        """
        Teste la vacuité de la File
        :return: (bool) True si la File est vide, False sinon
        :CU: None
        :Exemples:

        >>> q = File()
        >>> q.est_vide()
        True
        >>> q.enfile(1)
        >>> q.est_vide()
        False
        """
        return self.__contenu.est_vide()

    def enfile(self, el):
        """
        Enfile un élément dans la File
        :param el: (any) un élément
        :return: None
        :Side-Effet: ajoute un élément à la fin de la File
        :CU: None
        :Exemples:
        >>> q = File()
        >>> q.enfile(1)
        >>> q.defile() == 1
        True
        """
        self.__contenu.empile(el)

    def defile(self):
        """
        Défile un élément de la File
        :param el: (any) un élément
        :return: None
        :Side-Effet: enlève l'élément du début de la File
        :CU: None
        :Exemples:
        >>> q = File()
        >>> q.enfile(1)
        >>> q.defile() == 1
        True
        """
        pile1 = les_piles.Pile()       
        while not self.__contenu.est_vide():
            pile1.empile(self.__contenu.depile())
        resultat = pile1.depile()
        while not pile1.est_vide():
            self.__contenu.empile(pile1.depile())
        return resultat
    
    def __repr__(self):
        """
        >>> q = File()
        >>> q.enfile(1)
        >>> q.enfile(2)
        >>> q.enfile(3)
        >>> q
        3 2 1
        """
        pile1 = self.__contenu
        #pile1 = self
        resultat = ""
        while not pile1.est_vide():
            resultat += str(pile1.depile()) + " "
            #resultat = str(pile1.defile()) + " " + resultat
        if resultat == "":
            return resultat
        else:
            return resultat[:-1]

if __name__ == "__main__":
    import doctest
    doctest.testmod(verbose = True)


