from timeit import timeit
import pylab


def moyenne_temps(fonction_creation, fonction_recherche, nb_echantillons, taille_echantillon ):
    """
    Affiche un graphique ayant pour abscisse la taille d'une collection
    et en ordonnée la durée moyenne d'execution de la fonction recherche.
    :param fonction_creation:(str) une chaine de caractères correspondant à une fonction de création d'une collection
    :param fonction_recherche:(str) une chaine de caractères correspondant à une fonction de recherche dans une collection
    :param nb_echantillons:(int) un entier
    :param taille_echantillon:(int) un entier
    :CU: taille_echantillon >= 0
         nb_echantillons >= 0
    """    
    ordonnees = list()
    for i in range(taille_echantillon):
        duree = timeit(setup='from les_dictionnaires import '+fonction_creation+'; from les_dictionnaires import '+fonction_recherche, stmt=''+fonction_recherche+'('+fonction_creation+'('+str(taille_echantillon)+'),'+str(i)+')', number=nb_echantillons)
        moy = duree/nb_echantillons
        ordonnees.append(moy)
    abscisse=[i for i in range(taille_echantillon)]
    pylab.plot(abscisse,ordonnees)
    pylab.show()
    
#Question 7.
#La fonction moyenne_temps calcule le temps moyen que met la fonction
#fonction_recherche à s'exécuter avec nb_echantillons collections
#de taille comprise entre 0 et taille_echantillon-1
#Enfin, elle trace le graphique correspondant entre la taille
#des échantillons en abscisse et la durée en ordonnées

#moyenne_temps("creation_Liste", "recherche_Liste", 10, 100) 
#moyenne_temps("creation_Liste", "recherche_Liste", 10, 1000)
#moyenne_temps("creation_Dictionnaire", "recherche_dictionnaire", 10, 100)
#moyenne_temps("creation_Dictionnaire", "recherche_dictionnaire", 10, 10000)