import les_listes

def creation_Liste(n):
    """
    Crée une Liste des n premiers nombres entiers dans l'ordre croissant
    :param n:(int) un entier
    :return:(Liste) une Liste
    :CU: n >= 0
    :Exemples:
    >>> creation_Liste(5)
    (0.(1.(2.(3.(4.())))))
    """    
    ma_liste=les_listes.Liste()
    for i in range(n,0,-1):
        ma_liste=les_listes.Liste(i-1,ma_liste)
    return ma_liste

def creation_Dictionnaire(n):
    """
    Crée un Dictionnaire des n premiers nombres entiers dans l'ordre croissant
    :param n:(int) un entier
    :return:(dict) un Dictionnaire
    :CU: n >= 0
    :Exemples:
    >>> creation_Dictionnaire(5)
    {0: 0, 1: 1, 2: 2, 3: 3, 4: 4}
    """
    mon_dico=dict()
    for i in range(n):
        mon_dico[i]=i
    return mon_dico

def recherche_Liste(liste,i):
    """
    Renvoie le i-ème élément de la liste
    :param liste:(Liste) une Liste
    :param i:(int) un entier
    :CU: i >= 0
    :Exemples:
    >>> liste = creation_Liste(5)
    >>> recherche_Liste(liste,2)
    2
    """
    return liste.donne_element(i)

def recherche_dictionnaire(dictionnaire,i):
    """
    Renvoie l'élément du dictionnaire de clé i
    :param liste:(dict) un Dictionnaire
    :param i:(int) un entier
    :CU: i >= 0
    :Exemples:
    >>> dictionnaire = creation_Dictionnaire(5)
    >>> recherche_dictionnaire(dictionnaire,2)
    2
    """
    return dictionnaire[i]



    

if __name__ == "__main__":
    import doctest
    doctest.testmod(optionflags=doctest.NORMALIZE_WHITESPACE | doctest.ELLIPSIS, verbose=True)



