##### Syracuse #####

def syracuse(N, n):
    """
    renvoie le terme numéro n de la suite de syracuse du nombre N
    :param N:(int) un entier
    :param n:(int) un entier
    :return:(int) un entier
    :CU: N>0
    """
    if n == 0:
        return N
    else:
        if syracuse(N,n - 1) % 2 == 0:
            return syracuse(N,n - 1) // 2
        else:
            return 3 * syracuse(N,n - 1) + 1

def affiche_syracuse(N,n):
    for i in range(n+1):
        print(syracuse(N,i))

##### Récursivité terminale #####
# Question 1
from les_listes import Liste

def tableau_liste(tableau, acc = Liste()):
    """
    renvoie une Liste correspondant au tableau mis en paramètre
    :param tableau:(list) un tableau
    :return:(Liste) une Liste
    :CU:
    >>> tableau_liste([])
    ()
    >>> tableau_liste([1,2,3])
    (1.(2.(3.())))
    """    
    if tableau == []:
        return acc
    else:
        acc = Liste(tableau.pop(), acc)
        return tableau_liste(tableau, acc)

# Question 2
def est_present(carac, chaine):
    """
    prédicat de présence d'un caractère dans une chaîne de caractères
    :param carac:(string) une chaine de caractères
    :param chaine:(string) une chaine de caractères
    :return:(bool)
    :CU:  len(carac)=1
    >>> est_present('c', 'abraadabra')
    False
    >>> est_present('c', 'abracadabra')
    True
    """
    if chaine == '':
        return False
    elif carac == chaine[0]:
        return True
    else:
        return est_present(carac, chaine[1:])
    
##### Récursivité multiple #####
# Question 1
def fibonacci(n):
    """
    renvoie le terme numéro n de la suite de Fibonacci
    :param n:(int) un entier
    :return:(int) un entier
    >>> fibonacci(5)
    8
    >>> fibonacci(1)
    1
    
    """
    if n == 0 or n == 1:
        return 1
    else:
        return fibonacci(n - 2)+fibonacci(n - 1)

def rapport_fibo(n):
    """
    renvoie le rapport f(n+1)/f(n)
    :param n:(int) un entier
    :return:(float) un flottant
    >>> rapport_fibo(5)
    1.625
    >>> fibonacci(1)
    1

    """
    return fibonacci(n + 1) / fibonacci(n)

# il semblerait que le rapport tend vers 1.618 environ, soit le nombre d'or


# Question 2
import turtle

def von_koch(l,n):
    if n == 1:
        turtle.forward(l)
    else:
        von_koch(l/3,n-1)
        turtle.left(60)
        von_koch(l/3,n-1)
        turtle.right(120)
        von_koch(l/3,n-1)
        turtle.left(60)
        von_koch(l/3,n-1)
        
# il semblerait que la longueur du segment de Koch tende vers + infini


import doctest
doctest.testmod(verbose=False)