import random
#### Tri rapide ####

def tri_rapide(tableau, i=0, j=None):
    """
    trie un tableau
    :param tableau:(list) un tableau
    :param i:(int) un entier relatif
    :param j:(int) un entier relatif
    :Exemple:
    >>> l=[1, 9, 3, 5, 2, 6, 7, 8, 4]
    >>> tri_rapide(l)
    >>> l
    [1, 2, 3, 4, 5, 6, 7, 8, 9]
    """
    
    if j==None:
        j=len(tableau)-1
    if i<j:
        indice_pivot=placement(tableau,i,j)
        tri_rapide(tableau, i,indice_pivot-1)
        tri_rapide(tableau, indice_pivot+1,j)

def placement(tableau,i,j):
    """
    Choisit un pivot et place tous les éléments inférieurs à gauche du pivot
    et tous les éléments supérieurs à droite du pivot. Retourne l'indice du pivot.
    :param tableau:(list) un tableau
    :param i:(int) un entier relatif
    :param j:(int) un entier relatif
    :return:(int) l'indice du pivot
    :Exemple:
    >>> l=[1, 9, 3, 5, 2, 6, 7, 8, 4]
    >>> placement(l,3,8)
    5
    >>> l
    [1, 9, 3, 4, 2, 5, 7, 8, 6]
    """
    #indice_pivot=random.randint(i,j)
    #echanger(tableau,indice_pivot,i)
    indice_pivot=i
    pivot=tableau[indice_pivot]
    l=i+1
    r=j
    while l<=r:
        while l<=j and tableau[l]<pivot:
            l+=1
        while r>i and tableau[r]>=pivot:
            r-=1
        if l<r:
            echanger(tableau,l,r)
        
    echanger(tableau,indice_pivot,r)
    return r

def echanger(tableau,i,j):
    """
    echange deux éléments du tableau
    :param tableau:(list) un tableau
    :param i:(int) un entier
    :param j:(int) un entier
    :CU: 0<=i,j<len(tableau)
    :Exemple:
    >>> l=[1, 9, 3, 5, 2, 6, 7, 8, 4]
    >>> echanger(l,3,8)
    >>> l
    [1, 9, 3, 4, 2, 6, 7, 8, 5]
    """
    temp=tableau[i]
    tableau[i]=tableau[j]
    tableau[j]=temp
    
#### Recherche dichotomique dand un tableau trié ####

def rech_dicho(element, tableau, i=0, j=None):
    """
    recherche un élément dans un tableau trié
    :param tableau:(list) un tableau
    :param i:(int) un entier
    :param j:(int) un entier
    :CU: 0<=i,j<len(tableau)
    :Exemple:
    >>> l=[1, 2, 3, 4, 5, 6, 7, 8, 9]
    >>> rech_dicho(5,l)
    True
    >>> rech_dicho(12,l)
    False
    """
    if j == None:
        j = len(tableau) - 1
    if j < i:
        return False
    else:
        milieu = (i+j) // 2
        if tableau[milieu] == element:
            return True
        elif tableau[milieu] < element:
            return rech_dicho(element, tableau, i, milieu-1)
        else: 
            return rech_dicho(element, tableau, milieu+1, j)
            
def rech_dicho_terminale(element, tableau, i = 0, j = None, res = -1):
    """
    recherche un élément dans un tableau trié
    :param tableau:(list) un tableau
    :param i:(int) un entier
    :param j:(int) un entier
    :CU: 0<=i,j<len(tableau)
    :Exemple:
    >>> l=[1, 2, 3, 4, 5, 6, 7, 8, 9]
    >>> rech_dicho_terminale(5,l)
    4
    >>> rech_dicho_terminale(12,l)
    -1
    """
    if j == None:
        j = len(tableau) - 1
    if j < i:
        return res
    else:
        milieu = (i+j) // 2
        if tableau[milieu] == element:
            res = milieu
            return res
        elif tableau[milieu] < element:
            return rech_dicho_terminale(element, tableau, i, milieu - 1, res)
        else: 
            return rech_dicho_terminale(element, tableau, milieu + 1, j, res)

import doctest
doctest.testmod(verbose=True)