import data_villes
import networkx as nx
import matplotlib.pyplot as plt

####Création du graphe
villes=nx.Graph()
for el in data_villes.liste_des_villes:
    villes.add_node(el[0])
villes.add_edge('Lille','Lens')
villes.add_edge('Lille','Boulogne')
villes.add_edge('Lille','Paris')
villes.add_edge('Boulogne','Le Havre')
villes.add_edge('Le Havre','Caen')
villes.add_edge('Le Havre','Paris')
villes.add_edge('Caen','Paris')
villes.add_edge('Caen','Rennes')
villes.add_edge('Caen','Brest')
villes.add_edge('Rennes','Nantes')
villes.add_edge('Rennes','Paris')
villes.add_edge('Paris','Bordeaux')
villes.add_edge('Paris','Auxerre')
villes.add_edge('Paris','Strasbourg')
villes.add_edge('Strasbourg','Nancy')
villes.add_edge('Nancy','Metz')
villes.add_edge('Nancy','Sedan')
villes.add_edge('Lyon','Auxerre')
villes.add_edge('Lyon','Saint-Etienne')
villes.add_edge('Lyon','Annecy')
villes.add_edge('Lyon','Grenoble')
villes.add_edge('Lyon','Marseille')
villes.add_edge('Bordeaux','Toulouse')
villes.add_edge('Toulouse','Marseille')
villes.add_edge('Marseille','Nice')


####Dessin du graphe
nx.draw(villes, with_labels=True, font_weight='bold', node_size=800, node_color='lightgrey')
plt.show()


####Calculs sur les graphes
nombre_de_villes = len(data_villes.liste_des_villes)
nom_villes = { i : data_villes.liste_des_villes[i][0] for i in range(nombre_de_villes) }
numero_villes = { data_villes.liste_des_villes[i][0] : i for i in range(nombre_de_villes) }


####Matrice d'adjacence
def matrice_graphe(graphe):
    result=[[0 for i in range(graphe.number_of_nodes())] for j in range(graphe.number_of_nodes())]
    for el1 in graphe.nodes():
        for el2 in graphe.nodes():
            if (el1, el2) in villes.edges() or (el2, el1) in villes.edges():
                result[numero_villes[el1]][numero_villes[el2]]=1
                result[numero_villes[el2]][numero_villes[el1]]=1
    return result

matrice_adjacence = matrice_graphe(villes)

####Degré de Lyon
degre_Lyon=sum(matrice_adjacence[numero_villes['Lyon']])

####Chemins Lille-Marseille
chemins=list(nx.all_simple_paths(villes,'Lille','Marseille'))


####Ajout des poids
for el in villes.edges():
    villes[el[0]][el[1]]['weight']=data_villes.matrice_distance[numero_villes[el[0]]][numero_villes[el[1]]]
    

####Plus court chemin
plus_court_chemin=list(nx.shortest_path(villes,'Lille','Marseille'))


