import networkx as nx
import matplotlib.pyplot as plt

amis = nx.DiGraph()
amis.add_node('Henri')
amis.add_node('Jacqueline')
amis.add_node('Roger')
amis.add_node('Marcel')
amis.add_node('Bernadette')
amis.add_node('Jean')
amis.add_node('Anatole')

amis.add_edge('Henri','Marcel')
amis.add_edge('Jacqueline','Marcel')
amis.add_edge('Roger','Marcel')
amis.add_edge('Jacqueline','Roger')
amis.add_edge('Roger','Jacqueline')
amis.add_edge('Marcel','Bernadette')
amis.add_edge('Marcel','Jean')
amis.add_edge('Bernadette','Henri')
amis.add_edge('Bernadette','Anatole')
amis.add_edge('Anatole','Marcel')
amis.add_edge('Marcel','Anatole')

nx.draw(amis, with_labels=True, font_weight='bold', node_size=800, node_color='lightgrey',arrowsize=20)
plt.show()

def plus_d_amis(graphe):
    res=[]
    max=0
    for el in graphe.nodes:
        if nx.degree(graphe,el)>max:
            res=[el]
            max=nx.degree(graphe,el)
        elif nx.degree(graphe,el)==max:
            res.append(el)
    return res

def est_amis_du_plus_de_monde(graphe):
    res=[]
    maxi=0
    for el1 in graphe.nodes():
        nb_el1=0
        for el2 in graphe.nodes():
            if el1 in graphe.neighbors(el2):
                nb_el1+=1
        if nb_el1>maxi:
            res=[el1]
            maxi=nb_el1
        elif nb_el1==maxi:
            res.append(el1)
    return res

def amis_d_amis(graphe, personne):
    res=[]
    les_amis=graphe.neighbors(personne)
    for el1 in les_amis:
        les_amis_nouveaux=graphe.neighbors(el1)
        for el2 in les_amis_nouveaux:
            if el2 not in res:
                res.append(el2)
    return res

def cercle_amis(graphe):
    return list(nx.simple_cycles(graphe))