import mysql.connector

def connexion():
    return mysql.connector.connect(
      host="localhost",
      port=8889,
      user="root",
      password="root",
      database="bande_dessinnees"
    )

def fin_connexion(mydb):
    mydb.close()

def les_BD():
    
    mydb = connexion()
    
    curseur = mydb.cursor(buffered=True)
    
    requete="SELECT * FROM albums"
    curseur.execute(requete)
    ligne=curseur.fetchone()
    while ligne is not None:
      print(ligne)
      ligne=curseur.fetchone()
    
    curseur.close()
    
    fin_connexion(mydb)

def auteurs_festival(annee):
    
    mydb = connexion()
    
    curseur = mydb.cursor(buffered=True)
    
    requete="SELECT name FROM auteurs WHERE annee="+str(annee)
    curseur.execute(requete)
    ligne=curseur.fetchone()
    while ligne is not None:
      print(ligne[0])
      ligne=curseur.fetchone()
    
    curseur.close()
    
    fin_connexion(mydb)


def insereBD(titre, id_auteur, annee):
    mydb = connexion()
    
    curseur = mydb.cursor()
    data={'titre':titre, 'auteur':id_auteur, 'annee':annee}
    requete=("INSERT INTO albums (titre, auteur, annee) "
             "VALUES (%(titre)s,%(auteur)s,%(annee)s)"
            )
    curseur.execute(requete, data)
    mydb.commit()
    curseur.close()
    
    fin_connexion(mydb)
    
def albums(auteur):
    mydb = connexion()
    
    curseur = mydb.cursor()
    
    requete=("SELECT DISTINCT auteurs.name, albums.titre "
    "FROM auteurs "
    "JOIN albums "
    "ON albums.auteur=auteurs.id "
    "WHERE auteurs.name= %(auteur)s "
    )
    curseur.execute(requete, {'auteur':auteur})
    ligne=curseur.fetchone()
    while ligne is not None:
      print(ligne[0],": ", ligne[1])
      ligne=curseur.fetchone()
    
    curseur.close()
    
    fin_connexion(mydb)
  
def albums_et_auteur():
    mydb = connexion()
    
    curseur = mydb.cursor()
    
    requete=("SELECT DISTINCT auteurs.name, albums.titre "
    "FROM auteurs "
    "LEFT JOIN albums "
    "ON albums.auteur=auteurs.id "
    "ORDER BY auteurs.name"
    )
    curseur.execute(requete)
    ligne=curseur.fetchone()
    while ligne is not None:
      print(ligne[0],": ", ligne[1])
      ligne=curseur.fetchone()
    
    curseur.close()
    
    fin_connexion(mydb)
