import binary_tree as bt
import math
import les_files
import les_listes

def taille_arbre(arbre):
    if arbre.is_empty():
        return 0
    else:
        return 1 + taille_arbre(arbre.get_left_subtree()) + taille_arbre(arbre.get_right_subtree())

def hauteur_arbre(arbre):
    if arbre.is_empty():
        return -1
    else:
        return 1 + max(hauteur_arbre(arbre.get_left_subtree()), hauteur_arbre(arbre.get_right_subtree()))

def parcourir_arbre_infixe(arbre):
    res = ""
    if not arbre.is_empty():
        res += parcourir_arbre_infixe(arbre.get_left_subtree())
        res += str(arbre.get_data()) + "-"
        res += parcourir_arbre_infixe(arbre.get_right_subtree())
    return res

def parcourir_arbre_prefixe(arbre, res = None):
    if res == None:
        res = []
    if not arbre.is_empty():
        res.append(arbre.get_data())
        parcourir_arbre_prefixe(arbre.get_left_subtree())
        parcourir_arbre_prefixe(arbre.get_right_subtree())
    return res

def parcourir_arbre_suffixe(arbre, res = les_listes.Liste()):
    if not arbre.is_empty():
        res = parcourir_arbre_suffixe(arbre.get_left_subtree(), res)
        res = parcourir_arbre_suffixe(arbre.get_right_subtree(), res)
        res = les_listes.Liste(arbre.get_data(), res)
    return res

def parcourir_arbre_largeur_dabord(arbre, acc = les_files.File()):
    if not arbre.is_empty():
        print(arbre.get_data(), end = " - ")
        acc.enfile(arbre.get_left_subtree())
        acc.enfile(arbre.get_right_subtree())
    if not acc.est_vide():
        parcourir_arbre_largeur_dabord(acc.defile(), acc)

def creer_arbre_prefixe(taille, num = 1):
    vide = bt.BinaryTree()
    if taille != 0:
        n = int(math.log(taille, 2))
    if taille == 0:
        return vide
    elif taille == 2 ** n:
        return bt.BinaryTree(num, creer_arbre_prefixe(2 ** n - 1, num + 1), vide)
    else:
        return bt.BinaryTree(num, creer_arbre_prefixe(2 ** n - 1, num + 1),creer_arbre_prefixe(taille - 2 ** n, num + 2 ** n))


def creer_arbre_suffixe(taille, num = None):
    vide = bt.BinaryTree()
    if num == None:
        num = taille
    if taille != 0:
        n = int(math.log(taille, 2))
    if taille == 0:
        return vide
    elif taille == 2 ** n:
        return bt.BinaryTree(num, creer_arbre_suffixe(2 ** n - 1, num - 1), vide)
    else:
        return bt.BinaryTree(num, creer_arbre_suffixe(2 ** n - 1, num + 2 ** n - taille - 1), creer_arbre_suffixe(taille - 2 ** n, num - 1))

def creer_arbre_infixe(taille, num = None):
    vide = bt.BinaryTree()
    if taille != 0:
        n = int(math.log(taille, 2))
    if num == None:
        num = 2 ** n
    if taille == 0:
        return vide
    elif taille == 2 ** n:
        return bt.BinaryTree(num, creer_arbre_infixe(2 ** n - 1, num - 2 ** (n - 1)), vide)
    else:
        return bt.BinaryTree(num, creer_arbre_infixe(2 ** n - 1, num - 2 ** (n - 1)), creer_arbre_infixe(taille - 2 ** n, num + 2 ** (n - 1)))

def est_binaire_recherche(arbre):
    a = parcourir_arbre_infixe(arbre)
    for i in range(1, len(a)):
        if a[i] < a[i-1]:
            return False
    return True

def recherche_ABR(arbre, etiquette):
    if arbre.is_empty():
        return None
    elif arbre.get_data() == etiquette:
        return arbre
    elif arbre.get_data() > etiquette:
        return recherche_ABR(arbre.get_left_subtree(), etiquette)
    else:
        return recherche_ABR(arbre.get_right_subtree(), etiquette)
        

def inserer_ABR(arbre, etiquette):
    vide = bt.BinaryTree()
    if arbre.is_empty():
        return bt.BinaryTree(etiquette, vide, vide)
    if etiquette < arbre.get_data():
        arbre_gauche = inserer_ABR(arbre.get_left_subtree(), etiquette)
        arbre_droit = arbre.get_right_subtree()
        return bt.BinaryTree(arbre.get_data(), arbre_gauche, arbre_droit)
    elif etiquette > arbre.get_data():
        arbre_gauche = arbre.get_left_subtree()
        arbre_droit = inserer_ABR(arbre.get_right_subtree(), etiquette)
        return bt.BinaryTree(arbre.get_data(), arbre_gauche, arbre_droit)
    else:
        return bt.BinaryTree(etiquette, arbre, vide)
        
a=creer_arbre_infixe(12)
b=creer_arbre_prefixe(12)
c=creer_arbre_suffixe(12)
