class FileEmptyError(Exception):
    def __init__(msg):
        super().__init__(msg)

class File:
    """
    Une classe représentant les Files

    >>> q = File()
    >>> q.est_vide()
    True
    >>> q.enfile(1)
    >>> q.enfile(2)
    >>> q.est_vide()
    False
    >>> q.defile()
    1
    >>> q.defile()
    2
    """

    def __init__(self):
        """
        Crée une nouvelle File
        """
        self.contenu = []

    def est_vide(self):
        """
        Teste la vacuité de la File
        :return: (bool) True si la File est vide, False sinon
        :CU: None
        :Exemples:
        >>> q = File()
        >>> q.est_vide()
        True
        >>> q.enfile(1)
        >>> q.enfile(2)
        >>> q.est_vide()
        False
        """
        return self.contenu == []

    def enfile(self, el):
        """
        Enfile un élément dans la File
        :param el: (any) un élément
        :return: None
        :Side-Effet: ajoute un élément à la fin de la File
        :CU: None
        :Exemples:
        >>> q = File()
        >>> q.enfile(1)
        >>> q.enfile(2)
        >>> q.defile() == 1
        True
        """
        self.contenu.append(el)

    def defile(self):
        """
        Défile un élément de la File
        :param el: (any) un élément
        :return: None
        :Side-Effet: enlève l'élément du début de la File
        :CU: None
        :Exemples:
        >>> q = File()
        >>> q.enfile(1)
        >>> q.enfile(2)
        >>> q.defile() == 1
        True
        """
        return self.contenu.pop(0)
    
    def __repr__(self):
        """
        >>> q = File()
        >>> q.enfile(1)
        >>> q.enfile(2)
        >>> q.enfile(3)
        >>> q
        3 2 1
        """
        file = File()        
        resultat = ""
        while not self.est_vide():
            nb = self.defile()
            resultat = str(nb) + " " + resultat
            file.enfile(nb)
        while not file.est_vide():
            self.enfile(file.defile())
        if resultat == "":
            return resultat
        else:
            return resultat[:-1]


if __name__ == "__main__":
    import doctest
    doctest.testmod(verbose = False)

