from les_files import File

class Processus():
    etats = ("initialisation", "prêt", "élu", "bloqué", "terminé")
    
    def __init__(self, nom, duree):
        self.__duree = duree
        self.__etat = self.etats[0]
        self.__nom = nom
        
    def donne_nom(self):
        return self.__nom
    
    def donne_duree(self):
        return self.__duree
    
    def donne_etat(self):
        return self.__etat
    
    def bloquage(self):
        self.__etat = self.etats[3]
    
    def preemption(self):
        self.__etat = self.etats[1]
        
    def terminaison(self):
        self.__etat = self.etats[4]
    
    def election(self):
        self.__etat = self.etats[2]
        self.__duree = max(0,self.__duree - 1)
    
class Ordonnanceur():
    
    def __init__(self):
        self.__file = File()
        self.__instant = 0
        self.__processus_restants = []
    
    def ajoute_proc(self, nom, arrivee, duree):
        a = Processus(nom, duree)
        self.__processus_restants.append((arrivee, a))
    
    def ajoute_proc_file(self):
        i = 0
        for proc in self.__processus_restants:
            if proc[0] == self.__instant:
                self.__file.enfile(proc[1])
                self.__processus_restants.pop(i)
            i += 1
            
    def preempte(self, processus):
        processus.preemption()
        self.__file.enfile(processus)
    
    def termine(self, processus):
        processus.terminaison()
        
    def elir(self, processus):
        processus.election()
        if processus.donne_duree() == 0:
            processus.terminaison()
    
    def donne_processus_restants(self):
        return self.__processus_restants
    
    def donne_file(self):
        return self.__file
    
    def lancement(self):
        self.ajoute_proc_file()
        while self.__processus_restants != [] or not self.__file.est_vide():
            if not self.__file.est_vide():
                proc = self.__file.defile()
                self.elir(proc)
                self.__instant += 1
                self.ajoute_proc_file()
                if proc.donne_duree() != 0:
                    self.preempte(proc)
                else:
                    self.termine(proc)
                print(self.__instant, proc.donne_nom(), proc.donne_duree())
            else:
                self.__instant += 1
                self.ajoute_proc_file()
                print(self.__instant)
            
a = Ordonnanceur()            
a.ajoute_proc("P1", 0, 8)
a.ajoute_proc("P2", 2, 6)
a.ajoute_proc("P3", 3, 2)
a.ajoute_proc("P4", 7, 2)
a.lancement() 
    
    
