import networkx as nx
import math
import matplotlib.pyplot as plt

def creation_pyramide(*args):
    longueur=len(args)
    if int((-1+math.sqrt(1+8*longueur))/2)==(-1+math.sqrt(1+8*longueur))/2:
        nb_lignes=int((-1+math.sqrt(1+8*longueur))/2)
    else:
        nb_lignes=1+int((-1+math.sqrt(1+8*longueur))/2)
    liste=[]
    for el in args:
        liste.append(el)
    nb_elements=somme(nb_lignes)
    for i in range(nb_elements-longueur):
        liste.append(0)
    graphe=nx.DiGraph()
    for i in range(nb_lignes):
        if i==0:
            graphe.add_node((i,liste[i]))
        else:
            nombres_sur_ligne=i+1
            for j in range(nombres_sur_ligne):
                if j==0:
                    graphe.add_edge((i-1,liste[somme(i-1)]),(i,liste[somme(i)]))
                elif j==nombres_sur_ligne-1:
                    graphe.add_edge((i-1,liste[somme(i-1)+i-1]),(i,liste[somme(i)+i]))
                else:
                    graphe.add_edge((i-1,liste[somme(i-1)+j-1]),(i,liste[somme(i)+j]))
                    graphe.add_edge((i-1,liste[somme(i-1)+j]),(i,liste[somme(i)+j]))
    #nx.draw(graphe, with_labels=True, font_weight='regular', node_size=800, node_color='lightgrey',arrowsize=20)
    #plt.show()
    return liste

def somme(i):
    if i==0:
        return 0
    else:
        return i+somme(i-1)
    

  