

def cesar(texte, chiffre):
    resultat = ''
    alphabet = 'ABCDEFGHIJKLMNOPQRSTUVWXYZ'
    for caractere in texte:
        if caractere in alphabet:
            valeur_ascii = ord('A') + ((ord(caractere) - ord('A')) + chiffre) % 26
            resultat += chr(valeur_ascii)
        else:
            resultat += caractere
        
    return resultat

cesar('BONJOUR A TOUS. VIVE LA MATIERE NSI!',4)

def vigenere_chiffrement(texte, clef):
    resultat = ''
    alphabet = 'ABCDEFGHIJKLMNOPQRSTUVWXYZ'
    i  =0
    longueur_clef = len(clef)
    for caractere in texte:
        if i == len(clef):
            i = 0
        if caractere in alphabet:
            decalage = 1 + ord(clef[i]) - ord('A')
            resultat += cesar(caractere, decalage)
            i += 1
        else:
            resultat += caractere
    return resultat

def vigenere_dechiffrement(texte, clef):
    resultat = ''
    alphabet = 'ABCDEFGHIJKLMNOPQRSTUVWXYZ'
    i = 0
    longueur_clef = len(clef)
    for caractere in texte:
        if i == len(clef):
            i = 0
        if caractere in alphabet:
            decalage=1 + ord(clef[i]) - ord('A')
            resultat += cesar(caractere, -decalage)
            i += 1
        else:
            resultat += caractere
    return resultat

def chiffrement_XOR(texte, clef):
    resultat = ''
    i = 0
    longueur_clef = len(clef)
    for caractere in texte:
        if i == longueur_clef:
            i = 0
        resultat += chr(ord(caractere) ^ ord(clef[i]))
        i += 1
    return resultat


def pgcd(a,b):
    a,b = max(a, b), min(a, b)
    if b == 0:
        return a
    else:
        return pgcd(a-b, b)

def creation_cles(p, q):
    n = p * q
    phi = (p-1) * (q-1)
    e = 2
    while pgcd(e, phi) != 1 and e < phi:
        e += 1
    d=0
    while (d * e) % phi != 1:
        d += 1
    return (n, e), (n, d)

def chiffrement(cle_publique, nombre):
    n, e = cle_publique
    return (nombre ** e) % n

def dechiffrement(cle_privee, nombre):
    n, d = cle_privee
    return (nombre ** d) % n

def codage_RSA(texte, cle_publique):
    assert cle_publique[0] > 128
    resultat = ""
    for caractere in texte:
        code_ascii = ord(caractere)
        nouveau_code_ascii = chiffrement(cle_publique, code_ascii)
        resultat += chr(nouveau_code_ascii)
    return resultat

def decodage_RSA(texte, cle_privee):
    assert cle_privee[0] > 128
    resultat="" 
    for caractere in texte:
        code_ascii = ord(caractere)
        nouveau_code_ascii = dechiffrement(cle_privee, code_ascii)
        resultat += chr(nouveau_code_ascii)
    return resultat
    