ALPHABET = 'ABCDEFGHIJKLMNOPQRSTUVWXYZ'
MESSAGE_CLAIR = 'BONJOUR A TOUS. VIVE LA MATIERE NSI!'

def pgcd(a,b):
    a,b = min(a, b), max(a, b)
    if a == 0:
        return b
    else:
        return pgcd(a, b - a)

def creation_cles(p, q):
    n = p * q
    phi = (p-1) * (q-1)
    e = 2
    while pgcd(e, phi) != 1 and e < phi:
        e += 1
    d=0
    while (d * e) % phi != 1:
        d += 1
    return (n, e), (n, d)

def chiffrement(cle_publique, nombre):
    n, e = cle_publique
    return (nombre ** e) % n

def dechiffrement(cle_privee, nombre):
    n, d = cle_privee
    return (nombre ** d) % n

def codage_RSA(texte, cle_publique):
    assert cle_publique[0] > 128
    resultat = ""
    for caractere in texte:
        code_ascii = ord(caractere)
        nouveau_code_ascii = chiffrement(cle_publique, code_ascii)
        resultat += chr(nouveau_code_ascii)
    return resultat

def decodage_RSA(texte, cle_privee):
    assert cle_privee[0] > 128
    resultat="" 
    for caractere in texte:
        code_ascii = ord(caractere)
        nouveau_code_ascii = dechiffrement(cle_privee, code_ascii)
        resultat += chr(nouveau_code_ascii)
    return resultat

import random

def sac_supercroissant(nb):
    tableau = []
    while len(tableau) != nb:
        a = random.randint(1,1000)
        if a not in tableau:
            tableau.append(a)
    tableau.sort()
    return tableau

def generation_clef(nb):
    sac = sac_supercroissant(nb)
    N = random.randint(2,10) * sum(sac)
    A = N
    while pgcd(A, N) != 1:
        A = random.randint(1, N - 1)
    clef_privee = (N, A, sac)
    clef_publique = []
    for elt in sac:
        clef_publique.append((A * elt) % N)
    return clef_privee, clef_publique

def chiffrement_MH(carac, clef_publique):
    nb = bin(ord(carac))[2:]
    for k in range(8-len(nb)):
        nb = '0' + nb
    somme = 0
    for i in range(len(clef_publique)):
        somme += clef_publique[i] * int(nb[i])
    return somme

def inverse_mod(A, N):
    res = 1
    while (A * res) % N != 1:
        res += 1
    return res
    
def dechiffrement_MH(nombre, clef_privee):
    N, A, sac = clef_privee
    inv = inverse_mod(A, N)
    p = (inv * nombre) % N
    res = ""
    for i in range(len(sac)-1, -1, -1):
        if p - sac[i] >= 0:
            res = '1' + res
            p = p - sac[i]
        else:
            res = '0' + res
    lettre = chr(int(res, 2))
    return lettre

if __name__ == '__main__':
    import doctest
    doctest.testmod(verbose=False)